package com.netcertainty.webtier.b2b.pushevents;

import javax.ws.rs.*;

@Path("notification")
public class PushEvent
{

	@GET
	@Path("test/{txid}")
	public String test(@PathParam("txid") final String txid) {
	    return "testing, got transaction id: " + txid;
	}

	@GET
	@Path("complete/{txid}")
	@Produces({"application/json"})
	public Response txComplete(@PathParam("txid") final String txid) {
		Response action = new Response("complete", txid);
		return action;
	}

	@GET
	@Path("xml/sent/{txid}")
	@Produces({"application/xml"})
	public Response txCompleteJSON(@PathParam("txid") final String txid) {
		Response action = new Response("sent", txid);
		return action;
	}

	@GET
	@Path("sent/{txid}")
	@Produces({"application/json"})
	public Response txSent(@PathParam("txid") final String txid) {
		Response action = new Response("sent", txid);
		return action;
	}

	@GET
	@Path("suspend/{txid}")
	@Produces({"application/json"})
	public Response txSuspended(@PathParam("txid") final String txid) {
		Response action = new Response("suspend", txid);
		return action;
	}

	@GET
	@Path("cancel/{txid}")
	@Produces({"application/json"})
	public Response txCancelled(@PathParam("txid") final String txid) {
		Response action = new Response("cancel", txid);
		return action;
	}

	@GET
	@Path("version2")
	public String txPartyComplete(@QueryParam("action") String action, @QueryParam("id") String id, @QueryParam("ts") String ts, @QueryParam("pid") String pid,
			@QueryParam("refid") String refid) {
		return action + " " + id+" "+ts+" "+pid+" "+refid;
	}

}

